
/****** Object:  UserDefinedFunction [dbo].[UFD_RELA_FECHA_CAIXA]    Script Date: 07/22/2013 11:53:58 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_RELA_FECHA_CAIXA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_RELA_FECHA_CAIXA]
GO


/****** Object:  UserDefinedFunction [dbo].[UFD_RELA_FECHA_CAIXA]    Script Date: 07/22/2013 11:53:58 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*
	EMPRESA:	ITEC BRAZIL
	FUNCAO:		UFD_RELA_FECHA_CAIXA
	DT.CRIA:	27/10/2004
	RESP.CRIA:	CRISTIANO DE JESUS


	ULT.ALT:	03/08/2015
	RESP.ALT:	RAMAM FREITAS

	SELECT * FROM UFD_RELA_FECHA_CAIXA(1,'1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22','07/21/2015','07/28/2015')
	
	DECLARE @CD_EMP INT
	DECLARE @CD_FILIAL INT
	DECLARE @DT_MOV DATETIME
	
	SET @CD_EMP = 1
	SET @CD_FILIAL = 19
	SET @DT_MOV = '10/27/2004'

*/

CREATE FUNCTION [dbo].[UFD_RELA_FECHA_CAIXA] (
					@CD_EMP 		INT,
					@CD_FILIAL	VARCHAR(2500),
					@DT_INI		DATETIME,
					@DT_FIM		DATETIME
				      )


RETURNS @RS_RETORNO TABLE (
			CD_EMP				INT, 
			CD_FILIAL			INT, 
			NM_FANT				VARCHAR(150),
			VLR_SLD_INI			MONEY, 
			VLR_FUNDO_TROCO		MONEY, 
			VLR_DINH			MONEY, 
			VLR_CHQ_VISTA		MONEY, 
			VLR_TICKETS			MONEY, 
			VLR_DEV_VD			MONEY, 
			VLR_CHQ_PRZ			MONEY,  
			VLR_DUP				MONEY, 
			VLR_CONV			MONEY, 
			VLR_CONV_SEM_CAD 	MONEY, 
			VLR_CHQ_TROCO		MONEY, 
			VLR_DINHEIRO		MONEY,
			VLR_DESP			MONEY, 
			VLR_LEITURA_Z		MONEY, 
			VLR_CONSOLIDADO		MONEY,
			VLR_GESTAO_Z  		MONEY,
			VLR_GESTAO_DOC		MONEY, 
			VLR_CARTAO_VISTA 	MONEY,
			VLR_CARTAO_PRAZO 	MONEY,
			VLR_DINH_APURADO	MONEY, 
			VLR_DIF_DINHEIRO	MONEY,
			VLR_SOMA_DOC		MONEY,
			VLR_TEF				MONEY,
			VLR_TEF_DIG			MONEY,
			VLR_DIF_TEF			MONEY,
			VLR_CARTAO_PROPRIO  MONEY,
			VLR_DOACAO			MONEY,
			NR_ITENS_CUPONAGEM	MONEY,
			VLR_NCC_AMORTIZADA	MONEY,
			VLR_NCC_CANCELADA	MONEY, --ADICIONADO --ADEMILSON
			VLR_SERVICO         MONEY,
			VLR_CONV_PBM        MONEY,
			VLR_NF_SERIE_D      MONEY)

AS BEGIN

DECLARE @RS_PDV_VD	TABLE(CD_EMP		INT,
							CD_FILIAL 	INT,
							VLR_CARTAO	MONEY)
									
DECLARE @RS_PDV_TB_FILIAL TABLE(CD_EMP		INT,
								CD_FILIAL 	INT)

DECLARE @RS_FECHA_MOV TABLE (
			CD_EMP					INT, 
			CD_FILIAL				INT, 
			NM_FANT					VARCHAR(150),
			DT_MOV					DATETIME, 
			VLR_DINH				MONEY, 
			VLR_CHQ_VISTA			MONEY, 
			VLR_TICKETS				MONEY, 
			VLR_DEV_VD				MONEY, 
			VLR_CHQ_PRZ				MONEY,  
			VLR_DUP					MONEY, 
			VLR_CONV				MONEY, 
			VLR_CONV_SEM_CAD		MONEY, 
			VLR_CHQ_TROCO			MONEY, 
			VLR_DINHEIRO			MONEY, 
			VLR_SLD_INI				MONEY, 
			VLR_FUNDO_TROCO			MONEY, 
			VLR_DESP				MONEY, 
			VLR_LEITURA_Z			MONEY, 
			VLR_CONSOLIDADO			MONEY,
			VLR_DINH_APURADO		MONEY, 
			VLR_DIF_DINHEIRO		MONEY,
			VLR_CARTAO				MONEY,
			VLR_TEF_CONSL			MONEY,
			VLR_DEV_TEF				MONEY,
			VLR_POS_VISTA			MONEY,
			VLR_POS_PRAZO			MONEY,
			VLR_NCC_AMORTIZADA		MONEY,
			VLR_NCC_CANCELADA	    MONEY,--ADICIONADO -- ADEMILSON
			VLR_CARTAO_PROPRIO		MONEY,
			VLR_DOACAO				MONEY,
			NR_ITENS_CUPONAGEM		MONEY,
			VLR_SERVICO             MONEY,---ADICIONADO -- ADEMILSON
			VLR_CONV_PBM            MONEY,
			VLR_NF_SERIE_D          MONEY)
			
DECLARE @RS_CARTAO_VISTA TABLE (CD_EMP			INT,
								CD_FILIAL		INT, 
								VLR_CARTAO_VISTA	MONEY)

DECLARE @RS_CARTAO_PRAZO TABLE (CD_EMP			INT,
								CD_FILIAL		INT,
								VLR_CARTAO_PRAZO	MONEY)


DECLARE @RS_VD_CONSD_TEF TABLE (CD_EMP		INT,
								CD_FILIAL	INT,
								VLR_TEF_CONSL	MONEY)


DECLARE @RS_CARTAO_VISTA_POS TABLE (CD_EMP		INT,
									CD_FILIAL	INT,
									VLR_POS		MONEY)


DECLARE @RS_CARTAO_PRZ_POS TABLE (CD_EMP		INT,
									CD_FILIAL	INT,
									VLR_POS		MONEY)

									
/********************************************************************************************************/ 

	INSERT INTO @RS_PDV_TB_FILIAL
	SELECT DISTINCT @CD_EMP, ID FROM UFD_PRM_IN_STRING(@CD_FILIAL); 

/******************************************************************************************************/


-------------- BUSCANDO VD POR TEF QUE FORAM CONSOLIDADAS - TEF_CONSLD
	INSERT INTO @RS_VD_CONSD_TEF
	SELECT
		V.CD_EMP,
		V.CD_FILIAL,
		ISNULL(SUM(V.VLR_CARTAO),0) AS VLR_CARTAO
	FROM 
		PDV_VD  V
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		V.CD_EMP	=F.CD_EMP AND
		V.CD_FILIAL	=F.CD_FILIAL 
		
		LEFT JOIN PDV_VD_CANCEL_CONV C ON 
		V.CD_EMP = C.CD_EMP AND 
		V.CD_FILIAL = C.CD_FILIAL AND 
		V.CD_VD = C.CD_VD

		LEFT JOIN PDV_VD_CANCEL_TEF T ON  
		V.CD_EMP = T.CD_EMP AND 
		V.CD_FILIAL = T.CD_FILIAL AND 
		V.CD_VD = T.CD_VD 
	WHERE 
		V.CD_EMP = @CD_EMP 
		AND V.DT_VD BETWEEN @DT_INI AND @DT_FIM
		AND V.ST_VD = 0   
		AND T.CD_EMP IS NULL
		AND C.CD_EMP IS NULL
	GROUP BY
		V.CD_EMP,	
		V.CD_FILIAL

------ Buscando Vlr. Venda de TEF (CARTAO)
	INSERT INTO @RS_PDV_VD
	SELECT
		V.CD_EMP,
		V.CD_FILIAL,
		ISNULL(SUM(V.VLR_CARTAO),0) AS VLR_CARTAO
	FROM
		PDV_VD V
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		V.CD_EMP	=F.CD_EMP AND
		V.CD_FILIAL	=F.CD_FILIAL 
	WHERE
		V.CD_EMP = @CD_EMP
		AND V.DT_VD BETWEEN @DT_INI AND @DT_FIM
		AND V.ST_VD=0
	GROUP BY
		V.CD_EMP,
		V.CD_FILIAL;


--------- Buscando Vlr.Venda no Cartao de Debito - A vista

	INSERT INTO @RS_CARTAO_VISTA
	SELECT
		D.CD_EMP,
		D.CD_FILIAL,
		SUM(D.VLR_CARTAO)  VLR_CARTAO_VISTA
	FROM          

		PDV_VD_FECHA_RC_ADM_CARTAO_DEBITO D 
		INNER JOIN RC_ADM_CARTAO  A ON
		D.CD_EMP = A.CD_EMP AND 
		D.CD_ADM_CARTAO = A.CD_ADM_CARTAO
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		D.CD_EMP	=F.CD_EMP AND
		D.CD_FILIAL	=F.CD_FILIAL 

	WHERE 
		D.CD_EMP = @CD_EMP
		AND D.DT_MOV BETWEEN @DT_INI AND @DT_FIM
	 	AND A.TP_ADM <> 3
		AND D.FLAG_COMPOSICAO_LEITURA=0
	GROUP BY 
		D.CD_EMP,
		D.CD_FILIAL;

---------------------------------------------------------  
----------------------- BUSCA VLR POS DE CARTAO A VISTA
	INSERT INTO @RS_CARTAO_VISTA_POS
	SELECT     
		D.CD_EMP, 
		D.CD_FILIAL, 
		SUM(D.VLR_CARTAO)
	FROM         
		PDV_VD_FECHA_RC_ADM_CARTAO_DEBITO D
		INNER JOIN RC_ADM_CARTAO  A ON
		D.CD_EMP = A.CD_EMP AND 
		D.CD_ADM_CARTAO = A.CD_ADM_CARTAO
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		D.CD_EMP	=F.CD_EMP AND
		D.CD_FILIAL	=F.CD_FILIAL 
	WHERE
		D.CD_EMP = @CD_EMP
		AND D.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL))
		AND D.DT_MOV BETWEEN @DT_INI AND @DT_FIM
		AND A.TP_ADM = 3
		AND D.FLAG_COMPOSICAO_LEITURA=0
	GROUP BY 
		D.CD_EMP,
		D.CD_FILIAL;
---------------------------------------------------------  
-------------------------- BUSCA VLR POS DE CARTAO A PRAZO
	INSERT INTO @RS_CARTAO_PRZ_POS
	SELECT     
		D.CD_EMP, 
		D.CD_FILIAL, 
		SUM(D.VLR_CARTAO)
	FROM         
		PDV_VD_FECHA_RC_ADM_CARTAO_CREDITO D
		INNER JOIN RC_ADM_CARTAO  A ON
		D.CD_EMP = A.CD_EMP AND 
		D.CD_ADM_CARTAO = A.CD_ADM_CARTAO
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		D.CD_EMP	=F.CD_EMP AND
		D.CD_FILIAL	=F.CD_FILIAL 
	WHERE
		D.CD_EMP = @CD_EMP 
		AND D.DT_MOV BETWEEN @DT_INI AND @DT_FIM
		AND A.TP_ADM = 2
		AND D.FLAG_COMPOSICAO_LEITURA=0
	GROUP BY 
		D.CD_EMP,
		D.CD_FILIAL;

---------------------------------------------------------  
------- Buscando Vlr.Venda no Cartao de Credito - A Prazo

	INSERT INTO @RS_CARTAO_PRAZO  
	SELECT
		D.CD_EMP,
		D.CD_FILIAL, 
		SUM(D.VLR_CARTAO)  VLR_CARTAO_PRAZO
	FROM         
		PDV_VD_FECHA_RC_ADM_CARTAO_CREDITO D
		INNER JOIN RC_ADM_CARTAO  A ON
		D.CD_EMP = A.CD_EMP AND 
		D.CD_ADM_CARTAO = A.CD_ADM_CARTAO
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		D.CD_EMP	=F.CD_EMP AND
		D.CD_FILIAL	=F.CD_FILIAL 
	WHERE 
		D.CD_EMP = @CD_EMP 
		AND D.DT_MOV BETWEEN @DT_INI AND @DT_FIM
		AND A.TP_ADM <> 2
		AND D.FLAG_COMPOSICAO_LEITURA=0
	GROUP BY 
		D.CD_EMP,
		D.CD_FILIAL 

------------------- Buscando dados refente ao Fechamento
	INSERT INTO @RS_FECHA_MOV
	SELECT 
		FECHA_MOV.CD_EMP, 
		FECHA_MOV.CD_FILIAL, 
		PRC_FILIAL.NM_FANT,
		FECHA_MOV.DT_MOV, 
		FECHA_MOV.VLR_DINH, 
		FECHA_MOV.VLR_CHQ_VISTA, 
		FECHA_MOV.VLR_TICKETS, 
		FECHA_MOV.VLR_DEV_VD, 
		FECHA_MOV.VLR_CHQ_PRZ,  
		FECHA_MOV.VLR_DUP, 
		FECHA_MOV.VLR_CONV, 
		FECHA_MOV.VLR_CONV_SEM_CAD, 
		FECHA_MOV.VLR_CHQ_TROCO, 
		FECHA_MOV.VLR_DINHEIRO,
		FECHA_MOV.VLR_SLD_INI, 
		FECHA_MOV.VLR_FUNDO_TROCO, 
		FECHA_MOV.VLR_DESP, 
		FECHA_MOV.VLR_LEITURA_Z, 
		FECHA_MOV.VLR_CONSOLIDADO,
		(VLR_SLD_INI + FECHA_MOV.VLR_DINH  + ISNULL(FECHA_MOV.VLR_DOACAO,0) + ISNULL(FECHA_MOV.VLR_NF_SERIE_D,0) -
        (VLR_FUNDO_TROCO + FECHA_MOV.VLR_DESP + ISNULL(FECHA_MOV.VLR_NCC_AMORTIZADA,0) + 
        ISNULL(FECHA_MOV.VLR_NCC_CANCELADA_DINH,0) + ISNULL(FECHA_MOV.VLR_NCC_CANCELADA_CONV_CARTAO_DUP, 0))) AS VLR_DINH_APURADO,
		((VLR_SLD_INI + FECHA_MOV.VLR_DINH + ISNULL(FECHA_MOV.VLR_DOACAO,0) + ISNULL(FECHA_MOV.VLR_NF_SERIE_D,0) - (VLR_FUNDO_TROCO + FECHA_MOV.VLR_DESP)) - FECHA_MOV.VLR_DINHEIRO) AS VLR_DIF_DINHEIRO,
		ISNULL(RS_PDV_VD.VLR_CARTAO,0),
		ISNULL(RS_VD_CONSD_TEF.VLR_TEF_CONSL,0),
		FECHA_MOV.VLR_DEV_TEF,
		ISNULL(RS_CARTAO_VISTA_POS.VLR_POS,0), -- POS VISTA
		ISNULL(RS_CARTAO_PRZ_POS.VLR_POS,0), -- POS PRAZO,
		ISNULL(FECHA_MOV.VLR_NCC_AMORTIZADA,0),
		ISNULL(FECHA_MOV.VLR_NCC_CANCELADA,0),-- ADICIONADO -- ADEMILSON
		ISNULL(FECHA_MOV.VLR_CARTAO_PROPRIO,0),
		ISNULL(FECHA_MOV.VLR_DOACAO,0),
		ISNULL(FECHA_MOV.NR_ITENS_CUPONAGEM,0),
		ISNULL(FECHA_MOV.VLR_SERVICO,0), --- ADICIONADO -- ADEMILSON
		ISNULL(FECHA_MOV.VLR_CONV_PBM,0),
		ISNULL(VLR_NF_SERIE_D,0) AS VLR_NF_SERIE_D
		
	FROM 
		PDV_VD_FECHA_MOV FECHA_MOV 
		INNER JOIN PRC_FILIAL ON
		FECHA_MOV.CD_EMP = PRC_FILIAL.CD_EMP AND
		FECHA_MOV.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		LEFT JOIN @RS_PDV_VD RS_PDV_VD ON
		FECHA_MOV.CD_EMP = RS_PDV_VD.CD_EMP AND
		FECHA_MOV.CD_FILIAL = RS_PDV_VD.CD_FILIAL
		LEFT JOIN @RS_VD_CONSD_TEF RS_VD_CONSD_TEF ON
		FECHA_MOV.CD_EMP = RS_VD_CONSD_TEF.CD_EMP AND
		FECHA_MOV.CD_FILIAL = RS_VD_CONSD_TEF.CD_FILIAL
		LEFT JOIN @RS_CARTAO_PRZ_POS RS_CARTAO_PRZ_POS ON
		FECHA_MOV.CD_EMP = RS_CARTAO_PRZ_POS.CD_EMP AND
		FECHA_MOV.CD_FILIAL = RS_CARTAO_PRZ_POS.CD_FILIAL
		LEFT JOIN @RS_CARTAO_VISTA_POS RS_CARTAO_VISTA_POS ON
		FECHA_MOV.CD_EMP = RS_CARTAO_VISTA_POS.CD_EMP AND
		FECHA_MOV.CD_FILIAL = RS_CARTAO_VISTA_POS.CD_FILIAL
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		FECHA_MOV.CD_EMP	=F.CD_EMP AND
		FECHA_MOV.CD_FILIAL	=F.CD_FILIAL 
	WHERE 
		FECHA_MOV.CD_EMP = @CD_EMP
		AND FECHA_MOV.DT_MOV BETWEEN @DT_INI AND @DT_FIM;

---------------------------------------------------------
---------------------------- BUSCANDO O SLD INICIAL DE CADA LOJA DO PERIODO INFORMADO

	DECLARE @RS_SLD_INICIAL TABLE (	CD_EMP 		INT,			
									CD_FILIAL	INT,
									SLD_INICIAL	MONEY)

	INSERT INTO @RS_SLD_INICIAL
	SELECT
		FECHA_MOV.CD_EMP,
		FECHA_MOV.CD_FILIAL,
		FECHA_MOV.VLR_SLD_INI
	FROM
		PDV_VD_FECHA_MOV FECHA_MOV
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		FECHA_MOV.CD_EMP	=F.CD_EMP AND
		FECHA_MOV.CD_FILIAL	=F.CD_FILIAL 
	WHERE
		FECHA_MOV.CD_EMP = @CD_EMP 
		AND FECHA_MOV.DT_MOV = @DT_INI

--------------------------------------------------------------------------------------
--------------------------------- BUSCANDO O FUNDO DE TROCO DE CADA FILIAL
DECLARE @RS_FUNDO_TROCO TABLE (CD_EMP		INT,
								CD_FILIAL	INT,
								VLR_FUNDO_TROCO	MONEY)

	INSERT INTO @RS_FUNDO_TROCO
	SELECT
		FECHA_MOV.CD_EMP,
		FECHA_MOV.CD_FILIAL,
		FECHA_MOV.VLR_FUNDO_TROCO
	FROM
		PDV_VD_FECHA_MOV FECHA_MOV
		INNER JOIN @RS_PDV_TB_FILIAL F ON 
		FECHA_MOV.CD_EMP	=F.CD_EMP AND
		FECHA_MOV.CD_FILIAL	=F.CD_FILIAL 
	WHERE
		FECHA_MOV.CD_EMP = @CD_EMP
		AND FECHA_MOV.DT_MOV = @DT_FIM;

------------------------------------------------------------------------------

	INSERT INTO @RS_RETORNO
	SELECT
		RS_FECHA_MOV.CD_EMP, 
		RS_FECHA_MOV.CD_FILIAL, 
		RS_FECHA_MOV.NM_FANT,
		ISNULL(RS_SLD_INICIAL.SLD_INICIAL,0),
		ISNULL(RS_FUNDO_TROCO.VLR_FUNDO_TROCO,0),
		SUM(RS_FECHA_MOV.VLR_DINH), 
		SUM(RS_FECHA_MOV.VLR_CHQ_VISTA), 
		SUM(RS_FECHA_MOV.VLR_TICKETS), 
		SUM(RS_FECHA_MOV.VLR_DEV_VD), 
		SUM(RS_FECHA_MOV.VLR_CHQ_PRZ),  
		SUM(RS_FECHA_MOV.VLR_DUP), 
		SUM(RS_FECHA_MOV.VLR_CONV), 
		SUM(RS_FECHA_MOV.VLR_CONV_SEM_CAD), 
		SUM(RS_FECHA_MOV.VLR_CHQ_TROCO), 
		SUM(RS_FECHA_MOV.VLR_DINHEIRO),
		SUM(RS_FECHA_MOV.VLR_DESP), 
		SUM(RS_FECHA_MOV.VLR_LEITURA_Z), 
		SUM(RS_FECHA_MOV.VLR_CONSOLIDADO),
		(SUM(RS_FECHA_MOV.VLR_CONSOLIDADO) - SUM(RS_FECHA_MOV.VLR_LEITURA_Z)) AS VLR_GESTAO_Z,	 
		((SUM(RS_FECHA_MOV.VLR_DINH) + SUM(RS_FECHA_MOV.VLR_CHQ_VISTA) + ISNULL(RS_CARTAO_VISTA.VLR_CARTAO_VISTA,0) + 
			ISNULL(RS_CARTAO_PRAZO.VLR_CARTAO_PRAZO,0) + ISNULL(VLR_POS_VISTA,0)+ ISNULL(VLR_POS_PRAZO,0) + SUM(RS_FECHA_MOV.VLR_TICKETS) + 	
			SUM(RS_FECHA_MOV.VLR_DEV_VD) + SUM(RS_FECHA_MOV.VLR_CHQ_PRZ) + SUM(RS_FECHA_MOV.VLR_DUP) + SUM(RS_FECHA_MOV.VLR_CONV) + 
			SUM(RS_FECHA_MOV.VLR_CONV_SEM_CAD)  + SUM(RS_FECHA_MOV.VLR_CONV_PBM)) 
			- (SUM(RS_FECHA_MOV.VLR_CONSOLIDADO) + SUM(RS_FECHA_MOV.VLR_NCC_AMORTIZADA)+ SUM(RS_FECHA_MOV.VLR_SERVICO))) AS VLR_GESTAO_DOC, ---- ADMEILSON
				 
		
		(ISNULL(RS_CARTAO_VISTA.VLR_CARTAO_VISTA,0) + ISNULL(VLR_POS_VISTA,0)),
		(ISNULL(RS_CARTAO_PRAZO.VLR_CARTAO_PRAZO,0) + ISNULL(VLR_POS_PRAZO,0)),
				
		SUM(RS_FECHA_MOV.VLR_DINH_APURADO), 
		SUM(RS_FECHA_MOV.VLR_DIF_DINHEIRO),
		0,
		(RS_FECHA_MOV.VLR_TEF_CONSL) AS VLR_TEF,		
		--((SUM(ISNULL(RS_CARTAO_VISTA.VLR_CARTAO_VISTA,0)) + SUM(ISNULL(RS_CARTAO_PRAZO.VLR_CARTAO_PRAZO,0))) + (VLR_POS_VISTA + VLR_POS_PRAZO)) AS VLR_TEF_DIG,		
		((ISNULL(RS_CARTAO_VISTA.VLR_CARTAO_VISTA,0)) + ISNULL(RS_CARTAO_PRAZO.VLR_CARTAO_PRAZO,0) + (VLR_POS_VISTA + VLR_POS_PRAZO)) AS VLR_TEF_DIG,		
		 
				
		RS_FECHA_MOV.VLR_TEF_CONSL - ((ISNULL(RS_CARTAO_VISTA.VLR_CARTAO_VISTA,0) 	+ ISNULL(RS_CARTAO_PRAZO.VLR_CARTAO_PRAZO,0) + 
		ISNULL(VLR_POS_VISTA,0) + ISNULL(VLR_POS_PRAZO,0))) AS VLR_TEF_DIFERENCA,		
		
		ISNULL(SUM(VLR_CARTAO_PROPRIO),0),
		ISNULL(SUM(VLR_DOACAO),0),
		ISNULL(SUM(NR_ITENS_CUPONAGEM),0),
		ISNULL(SUM(VLR_NCC_AMORTIZADA),0),
		ISNULL(SUM(VLR_NCC_CANCELADA),0),
		ISNULL(SUM(VLR_SERVICO),0),
		ISNULL(SUM(VLR_CONV_PBM),0),
		ISNULL(SUM(VLR_NF_SERIE_D),0)
	FROM
		@RS_FECHA_MOV RS_FECHA_MOV 
		LEFT JOIN @RS_SLD_INICIAL RS_SLD_INICIAL ON 
		RS_FECHA_MOV.CD_EMP = RS_SLD_INICIAL.CD_EMP AND
		RS_FECHA_MOV.CD_FILIAL = RS_SLD_INICIAL.CD_FILIAL 
		
		LEFT JOIN @RS_FUNDO_TROCO RS_FUNDO_TROCO ON 
		RS_FECHA_MOV.CD_EMP = RS_FUNDO_TROCO.CD_EMP AND 
		RS_FECHA_MOV.CD_FILIAL = RS_FUNDO_TROCO.CD_FILIAL
 		
		LEFT JOIN @RS_CARTAO_VISTA RS_CARTAO_VISTA ON 
		RS_FECHA_MOV.CD_EMP = RS_CARTAO_VISTA.CD_EMP AND
		RS_FECHA_MOV.CD_FILIAL = RS_CARTAO_VISTA.CD_FILIAL 
			
		LEFT JOIN @RS_CARTAO_PRAZO RS_CARTAO_PRAZO ON 
		RS_FECHA_MOV.CD_EMP = RS_CARTAO_PRAZO.CD_EMP AND
		RS_FECHA_MOV.CD_FILIAL = RS_CARTAO_PRAZO.CD_FILIAL 
		
	GROUP BY
		RS_FECHA_MOV.CD_EMP, 
		RS_FECHA_MOV.CD_FILIAL, 
		RS_FECHA_MOV.NM_FANT,
		RS_SLD_INICIAL.SLD_INICIAL,
		RS_FUNDO_TROCO.VLR_FUNDO_TROCO,
		RS_FECHA_MOV.VLR_CARTAO,
		RS_FECHA_MOV.VLR_TEF_CONSL,
		VLR_POS_VISTA,	
		VLR_POS_PRAZO,
		VLR_CARTAO_VISTA,
		VLR_CARTAO_PRAZO		


RETURN
END
GO


